// Persistence of Vision Ray Tracer Scene Description File
// File: macro tornado.pov
// Vers: unofficial MegaPov 0.4>
// Desc: macro to create either a tornado, dustdevil, or whirlwind. 1 Unit = 10 Meters.
// Date: 00.3, 01.45
// Auth: Bob Hughes
// Mail: omniverse@charter.net
// Note: clockmod.inc is used for animation, not needed for stills.
// The Clock Modifier Include is at  http://www.geocities.com/ccolefax/


#version unofficial MegaPov 0.7;


// include this file in your scenes
#include "macro tornado.mcr"

// tornado macro
Tornado (
 "t",             // type [d = dustdevil, t = tornado, w = whirlwind] (lowercase letters)
 <20,0,5>,        // start position (d,t,w)
 <-40,0,-15>,     // translation vector (amount and direction to move) (d,t,w)
 300,             // max height [<300>] (d,t)
 50-(25*clock),   // min height [<0<30?<(max height/5)] (d,t)
 20+(20*clock),   // upper width [>0<100>?] (d,t)
 2.5+(7.5*clock), // lower width [>0<25>?] (d,t,w)
 10+(5*clock),    // curving deviation [0<25>?] (d,t)
 123,             // random seed [any positive integer] (d,t)
 <1,1+clock/2,1>, // color shift of dust plume [any number] (negatives subtract) (w)
 <1,1,1-clock/3>, // color shift of halo [any number] (negatives subtract) (d)
 <1-clock/4,1,1>, // color shift of funnel [any number] (negatives subtract) (t)
 1/3+(1/3*clock), // media scattering multiplier, arbitrary value [0<.25 to 2>?] (d,t,w)
 3,               // additional media samples [-1 to 9?] (more is slower, better) (d,t,w)
 on,              // halo [on or off] (d,t)
 .5+(clock*.375), // halo height [0 to 1] (d,t)
 yes              // animate [yes or no] (clockmod.inc needed if yes) (d,t,w)
 )


/* test scene: road and power poles are about 15 times closer to camera than the tornado */

global_settings {
        assumed_gamma 2.4
        max_trace_level 10
      //  motion_blur 6,.06
}

// close-in sunlight because of small sphere used as sky
light_source {<300,300,-400>, <1.5,1.33,1.25>
        media_attenuation on
}

light_source {<0,500,0>, <.15,.2,.25>
         shadowless
}

camera {
  location  <0,.5,-250>
  angle 50
  look_at   <5-(25*clock),75,0>
}

// ground
plane {y,0 pigment {rgb<.9,.8,.4>} normal {granite .4 scale .2} finish {diffuse .8}}

// house
union {
box {<-.75,-.75,-.5>,<.75,.75,.5>
        pigment {rgb .1} finish {ambient .05 diffuse .75}
  rotate -45*z scale <1.025,.67,1.025> translate .5*y
        clipped_by {plane {-y,-.5}}
}
box {<-.75,0,-.67>,<.75,.5,.67>
        pigment {checker color 1,.5 scale <.125,.133,1>} finish {ambient .5 diffuse .75}
}
  translate <-10,0,-175>
}

// power poles
union {
#declare C=10;
#while (C>0)
union {
 cone {0,.067,1.25*y,.05}
 box {-1,1 scale <.03,.033,.35> translate <.075,.95,0>}
 box {-1,1 scale <.03,.033,.35> translate <.075,1.1,0>}
 sphere {0,.025 pigment {rgbf<.6,.9,.8,.7>} scale <1,1.5,1> translate <.075,.967,-.275>}
 sphere {0,.025 pigment {rgbf<.6,.9,.8,.7>} scale <1,1.5,1> translate <.075,.967,.275>}
 torus {1,.01 rotate 90*x clipped_by {box {<-.5,-1.05,-.05>,<.5,.25,.05>}} scale <5,1.5,1> translate <2.5,2.3,-.275>}
 torus {1,.01 rotate 90*x clipped_by {box {<-.5,-1.05,-.05>,<.5,.25,.05>}} scale <5,1.5,1> translate <2.5,2.3,.275>}
 torus {1,.0067 rotate 90*x clipped_by {box {<-.5,-1.05,-.05>,<.5,.25,.05>}} scale <5,1.5,1> translate <2.5,2.45,.275>}
  translate (-25+C*5)*x
 }
#declare C=C-1;
#end
// road
box {-1,1 pigment {rgb .5} scale <25,.025,1.25> translate <0,0,-2.25>}
 pigment {rgb<.5,.3,.2>}
  normal {granite .3 scale .05}
   finish {diffuse .7 specular .1 roughness .1}
  rotate 10*y translate <0,0,-234>
}

// sky
#declare StormClouds=
        texture {
        pigment {
                 bozo turbulence 1
                color_map {
                [0 rgb <.33,.3,.333>*.6]
                [.67 rgb <.5,.67,.75>*.7]
                [.75 rgb <.6,.7,.8>*.8]
        } scale .1 ramp_wave}
        finish {ambient .67 diffuse 0}
        }

#declare Sky=
        texture {
        pigment {
                 gradient y
                color_map {
                [0 rgb <.9,.88,.89>]
                [.2 rgb <.5,.67,.75>]
                [.5 rgb <.33,.67,1>]
        }}
        finish {ambient 1 diffuse 0}
        }

sphere {0,1
        texture {
                 gradient y
                texture_map {
                [0 Sky]
                [.3 Sky]
                [.5 StormClouds]
                [1 StormClouds]
        }
        }
      scale <800,400,600>
 hollow no_shadow
}

// air/rain
/*
fog {
        color <.6,.65,.7>
        distance 667
}
*/

fog {
        fog_type 2
        color <.6,.63,.67>
        distance 400
        fog_alt 60
        fog_offset 10
}
